/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.foundation.ponder;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public final class PonderEntry {
    private final ResourceLocation schematic;
    private final PonderStoryBoardEntry.PonderStoryBoard storyBoard;
    private final List<ResourceLocation> components = new ArrayList<ResourceLocation>();
    private final List<PonderTag> tags = new ArrayList<PonderTag>();

    public PonderEntry(ResourceLocation schematic, PonderStoryBoardEntry.PonderStoryBoard storyBoard) {
        this.schematic = schematic;
        this.storyBoard = storyBoard;
    }

    public void register() {
        for (ResourceLocation component : this.components) {
            PonderStoryBoardEntry entry = new PonderStoryBoardEntry(this.storyBoard, "create_central_kitchen", this.schematic, component);
            entry.highlightTags((PonderTag[])this.tags.toArray(PonderTag[]::new));
            PonderRegistry.addStoryBoard((PonderStoryBoardEntry)entry);
        }
    }

    @CanIgnoreReturnValue
    public PonderEntry addComponent(ResourceLocation ... components) {
        Collections.addAll(this.components, components);
        return this;
    }

    @SafeVarargs
    @CanIgnoreReturnValue
    public final PonderEntry addComponent(RegistryObject<? extends Item> ... components) {
        Arrays.stream(components).map(RegistryObject::getId).forEach(this.components::add);
        return this;
    }

    @CanIgnoreReturnValue
    public PonderEntry addComponent(ItemProviderEntry<?> ... components) {
        Arrays.stream(components).map(RegistryEntry::getId).forEach(this.components::add);
        return this;
    }

    @CanIgnoreReturnValue
    public PonderEntry addTag(PonderTag ... tags) {
        Collections.addAll(this.tags, tags);
        return this;
    }
}

